/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.mobs.entity;

import javax.annotation.Nonnull;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class SoulBeadEntity
extends Entity {
    private static final DataParameter<Integer> TARGET_X = EntityDataManager.func_187226_a(SoulBeadEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TARGET_Z = EntityDataManager.func_187226_a(SoulBeadEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private int liveTicks = 0;
    private static final String TAG_TARGET_X = "targetX";
    private static final String TAG_TARGET_Z = "targetZ";

    public SoulBeadEntity(EntityType<? extends SoulBeadEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public void setTarget(int x, int z) {
        this.field_70180_af.func_187227_b(TARGET_X, (Object)x);
        this.field_70180_af.func_187227_b(TARGET_Z, (Object)z);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(TARGET_X, (Object)0);
        this.field_70180_af.func_187214_a(TARGET_Z, (Object)0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        double posSpread = 0.4;
        double scale = 0.08;
        double rotateSpread = 1.5;
        double rise = 0.05;
        int maxLiveTime = 6000;
        int particles = 20;
        double trigArg = (double)this.liveTicks * 0.32;
        if (maxLiveTime - this.liveTicks < particles) {
            particles = maxLiveTime - this.liveTicks;
        }
        double posX = this.func_226277_ct_();
        double posY = this.func_226278_cu_();
        double posZ = this.func_226281_cx_();
        Vector3d vec = new Vector3d((double)((Integer)this.field_70180_af.func_187225_a(TARGET_X)).intValue(), posY, (double)((Integer)this.field_70180_af.func_187225_a(TARGET_Z)).intValue()).func_178786_a(posX, posY, posZ).func_72432_b().func_186678_a(scale);
        double bpx = posX + vec.field_72450_a * (double)this.liveTicks + Math.cos(trigArg) * rotateSpread;
        double bpy = posY + vec.field_72448_b * (double)this.liveTicks + (double)this.liveTicks * rise;
        double bpz = posZ + vec.field_72449_c * (double)this.liveTicks + Math.sin(trigArg) * rotateSpread;
        for (int i = 0; i < particles; ++i) {
            double px = bpx + (Math.random() - 0.5) * posSpread;
            double py = bpy + (Math.random() - 0.5) * posSpread;
            double pz = bpz + (Math.random() - 0.5) * posSpread;
            this.field_70170_p.func_195594_a((IParticleData)new RedstoneParticleData(0.2f, 0.12f, 0.1f, 1.0f), px, py, pz, 0.0, 0.0, 0.0);
            if (!(Math.random() < 0.05)) continue;
            this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197628_u, Blocks.field_150425_aM.func_176223_P()), px, py, pz, 0.0, 0.0, 0.0);
        }
        if (Math.random() < 0.1) {
            this.field_70170_p.func_184148_a(null, bpx, bpy, bpz, SoundEvents.field_187551_bH, SoundCategory.PLAYERS, 0.2f, 1.0f);
        }
        ++this.liveTicks;
        if (this.liveTicks > maxLiveTime || this.field_70170_p.func_180495_p(new BlockPos(bpx, bpy, bpz)).func_200132_m()) {
            this.func_241204_bJ_();
        }
    }

    public void func_213281_b(@Nonnull CompoundNBT compound) {
        this.field_70180_af.func_187227_b(TARGET_X, (Object)compound.func_74762_e(TAG_TARGET_X));
        this.field_70180_af.func_187227_b(TARGET_Z, (Object)compound.func_74762_e(TAG_TARGET_Z));
    }

    protected void func_70037_a(@Nonnull CompoundNBT compound) {
        compound.func_74768_a(TAG_TARGET_X, ((Integer)this.field_70180_af.func_187225_a(TARGET_X)).intValue());
        compound.func_74768_a(TAG_TARGET_Z, ((Integer)this.field_70180_af.func_187225_a(TARGET_Z)).intValue());
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

